<?php

/*
Plugin Name: Fs SEO
Plugin URI: https://fsh92.ir/fswd/fs-seo/
Description: افزونه ای برای سیو سایت-نسخه رایگان
Version: 1.0.0
Author: فرهام شایگان
Author URI: https://fsh92.ir/fswd/
Text Domain: fs-seo
License: GPL2
*/

if (!defined('ABSPATH')) exit;

class FSSEO {
    
    public function __construct() {
        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('add_meta_boxes', array($this, 'add_seo_meta_box'));
        add_action('save_post', array($this, 'save_seo_data'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts'));
        add_action('wp_head', array($this, 'add_meta_tags_to_frontend'));
    }
    
    public function add_admin_menu() {
        add_menu_page(
            'FS SEO',
            'FS SEO',
            'manage_options',
            'fs-seo',
            array($this, 'admin_dashboard'),
            'dashicons-search',
            80
        );
    }
    
    public function admin_dashboard() {
        ?>
        <div class="wrap">
            <h1>FS SEO Dashboard</h1>
            
            <div class="fs-seo-stats">
                <div class="fs-stat-card">
                    <h3>پست‌های بهینه‌شده</h3>
                    <div class="fs-stat-number">0</div>
                </div>
                <div class="fs-stat-card">
                    <h3>کلمات کلیدی</h3>
                    <div class="fs-stat-number">0</div>
                </div>
                <div class="fs-stat-card">
                    <h3>امتیاز متوسط</h3>
                    <div class="fs-stat-number">0%</div>
                </div>
            </div>
            
            <div class="fs-seo-settings">
                <h2>تنظیمات عمومی</h2>
                <form method="post" action="options.php">
                    <?php settings_fields('fs_seo_settings'); ?>
                    <table class="form-table">
                        <tr>
                            <th>ساختار عنوان پیش‌فرض</th>
                            <td>
                                <input type="text" name="fs_seo_title_pattern" value="<?php echo esc_attr(get_option('fs_seo_title_pattern', '{title} | {site}')); ?>" class="regular-text">
                                <p class="description">از {title} و {site} استفاده کنید</p>
                            </td>
                        </tr>
                        <tr>
                            <th>توضیحات متا پیش‌فرض</th>
                            <td>
                                <textarea name="fs_seo_description_pattern" class="large-text"><?php echo esc_textarea(get_option('fs_seo_description_pattern', '{excerpt}')); ?></textarea>
                            </td>
                        </tr>
                    </table>
                    <?php submit_button(); ?>
                </form>
            </div>
        </div>
        <?php
    }
    
    public function add_seo_meta_box() {
        $post_types = array('post', 'page');
        
        foreach ($post_types as $post_type) {
            add_meta_box(
                'fs_seo_meta_box',
                'FS SEO - آنالیز سئو',
                array($this, 'seo_meta_box_callback'),
                $post_type,
                'normal',
                'high'
            );
        }
    }
    
    public function seo_meta_box_callback($post) {
        wp_nonce_field('fs_seo_nonce_action', 'fs_seo_nonce_field');
        
        $focus_keyword = get_post_meta($post->ID, '_fs_seo_focus_keyword', true);
        $meta_title = get_post_meta($post->ID, '_fs_seo_meta_title', true);
        $meta_description = get_post_meta($post->ID, '_fs_seo_meta_description', true);
        $meta_robots = get_post_meta($post->ID, '_fs_seo_meta_robots', true);
        ?>
        
        <div class="fs-seo-container">
            <div class="fs-seo-tabs">
                <button type="button" class="fs-tab active" data-tab="general">عمومی</button>
                <button type="button" class="fs-tab" data-tab="advanced">پیشرفته</button>
            </div>
            
            <div class="fs-seo-content">
                <div class="fs-tab-pane active" id="general-tab">
                    <div class="fs-field">
                        <label for="fs_focus_keyword">کلمه کلیدی تمرکز:</label>
                        <input type="text" id="fs_focus_keyword" name="fs_focus_keyword" 
                               value="<?php echo esc_attr($focus_keyword); ?>" 
                               placeholder="کلمه کلیدی اصلی را وارد کنید">
                    </div>
                    
                    <div class="fs-preview">
                        <h4>پیشنمایش گوگل:</h4>
                        <div class="fs-preview-box">
                            <div class="fs-preview-title" id="fs-preview-title">
                                <?php echo $meta_title ? esc_html($meta_title) : get_the_title($post->ID); ?>
                            </div>
                            <div class="fs-preview-url">
                                <?php echo esc_url(get_permalink($post->ID)); ?>
                            </div>
                            <div class="fs-preview-desc" id="fs-preview-desc">
                                <?php echo $meta_description ? esc_html($meta_description) : wp_trim_words(get_the_excerpt($post->ID), 25); ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="fs-analysis">
                        <h4>آنالیز سئو:</h4>
                        <div class="fs-score">
                            <div class="fs-score-text">امتیاز: <span id="fs-score-value">0</span>/100</div>
                            <div class="fs-score-bar">
                                <div class="fs-score-fill" id="fs-score-fill"></div>
                            </div>
                        </div>
                        <div class="fs-checks">
                            <div class="fs-check-item" data-check="title">
                                <span class="fs-check-icon">○</span>
                                <span class="fs-check-text">عنوان سئو</span>
                            </div>
                            <div class="fs-check-item" data-check="description">
                                <span class="fs-check-icon">○</span>
                                <span class="fs-check-text">توضیحات متا</span>
                            </div>
                            <div class="fs-check-item" data-check="keyword">
                                <span class="fs-check-icon">○</span>
                                <span class="fs-check-text">کلمه کلیدی</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="fs-tab-pane" id="advanced-tab">
                    <div class="fs-field">
                        <label for="fs_meta_title">عنوان متا:</label>
                        <input type="text" id="fs_meta_title" name="fs_meta_title" 
                               value="<?php echo esc_attr($meta_title); ?>" 
                               placeholder="عنوان متا (50-60 کاراکتر)">
                        <div class="fs-char-count">تعداد کاراکتر: <span id="title-chars">0</span></div>
                    </div>
                    
                    <div class="fs-field">
                        <label for="fs_meta_description">توضیحات متا:</label>
                        <textarea id="fs_meta_description" name="fs_meta_description" 
                                  placeholder="توضیحات متا (150-160 کاراکتر)"><?php echo esc_textarea($meta_description); ?></textarea>
                        <div class="fs-char-count">تعداد کاراکتر: <span id="desc-chars">0</span></div>
                    </div>
                    
                    <div class="fs-field">
                        <label for="fs_meta_robots">دستورات ربات‌ها:</label>
                        <select id="fs_meta_robots" name="fs_meta_robots">
                            <option value="">پیش‌فرض</option>
                            <option value="index,follow" <?php selected($meta_robots, 'index,follow'); ?>>index, follow</option>
                            <option value="noindex,follow" <?php selected($meta_robots, 'noindex,follow'); ?>>noindex, follow</option>
                            <option value="index,nofollow" <?php selected($meta_robots, 'index,nofollow'); ?>>index, nofollow</option>
                            <option value="noindex,nofollow" <?php selected($meta_robots, 'noindex,nofollow'); ?>>noindex, nofollow</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
    
    public function save_seo_data($post_id) {
        if (!isset($_POST['fs_seo_nonce_field']) || 
            !wp_verify_nonce($_POST['fs_seo_nonce_field'], 'fs_seo_nonce_action')) {
            return;
        }
        
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }
        
        if (!current_user_can('edit_post', $post_id)) {
            return;
        }
        
        $fields = array(
            'fs_focus_keyword' => '_fs_seo_focus_keyword',
            'fs_meta_title' => '_fs_seo_meta_title',
            'fs_meta_description' => '_fs_seo_meta_description',
            'fs_meta_robots' => '_fs_seo_meta_robots'
        );
        
        foreach ($fields as $field => $meta_key) {
            if (isset($_POST[$field])) {
                $value = sanitize_text_field($_POST[$field]);
                update_post_meta($post_id, $meta_key, $value);
            }
        }
    }
    
    public function enqueue_scripts($hook) {
        if ('post.php' != $hook && 'post-new.php' != $hook) {
            return;
        }
        
        wp_enqueue_style('fs-seo-css', plugins_url('fs-seo.css', __FILE__));
        wp_enqueue_script('fs-seo-js', plugins_url('fs-seo.js', __FILE__), array('jquery'), '1.0.0', true);
    }
    
    public function add_meta_tags_to_frontend() {
        if (is_singular()) {
            global $post;
            
            $meta_title = get_post_meta($post->ID, '_fs_seo_meta_title', true);
            $meta_description = get_post_meta($post->ID, '_fs_seo_meta_description', true);
            $meta_robots = get_post_meta($post->ID, '_fs_seo_meta_robots', true);
            
            if ($meta_title) {
                echo '<meta name="title" content="' . esc_attr($meta_title) . '">' . "\n";
            }
            
            if ($meta_description) {
                echo '<meta name="description" content="' . esc_attr($meta_description) . '">' . "\n";
            }
            
            if ($meta_robots) {
                echo '<meta name="robots" content="' . esc_attr($meta_robots) . '">' . "\n";
            }
        }
    }
}

new FSSEO();

// ثبت تنظیمات
add_action('admin_init', function() {
    register_setting('fs_seo_settings', 'fs_seo_title_pattern', array(
        'sanitize_callback' => 'sanitize_text_field'
    ));
    register_setting('fs_seo_settings', 'fs_seo_description_pattern', array(
        'sanitize_callback' => 'sanitize_textarea_field'
    ));
});
?>