jQuery(document).ready(function($) {
    // مدیریت تب‌ها
    $('.fs-tab').on('click', function() {
        $('.fs-tab').removeClass('active');
        $(this).addClass('active');
        
        $('.fs-tab-pane').removeClass('active');
        $('#' + $(this).data('tab') + '-tab').addClass('active');
    });
    
    // شمارش کاراکترها
    function updateCharCount() {
        var titleLength = $('#fs_meta_title').val().length;
        var descLength = $('#fs_meta_description').val().length;
        
        $('#title-chars').text(titleLength);
        $('#desc-chars').text(descLength);
    }
    
    $('#fs_meta_title, #fs_meta_description').on('input', updateCharCount);
    updateCharCount();
    
    // بروزرسانی پیشنمایش گوگل
    function updateGooglePreview() {
        var title = $('#fs_meta_title').val() || $('h1.wp-block-post-title').text() || $('title').text();
        var description = $('#fs_meta_description').val() || $('#excerpt').val() || '';
        
        $('#fs-preview-title').text(title.substring(0, 60));
        $('#fs-preview-desc').text(description.substring(0, 160));
    }
    
    $('#fs_meta_title, #fs_meta_description').on('input', updateGooglePreview);
    updateGooglePreview();
    
    // آنالیز سئو
    function analyzeSEO() {
        var focusKeyword = $('#fs_focus_keyword').val();
        var title = $('#fs_meta_title').val();
        var description = $('#fs_meta_description').val();
        
        var score = 0;
        var totalChecks = 3;
        
        // بررسی عنوان
        if (title && title.length >= 15 && title.length <= 60) {
            $('.fs-check-item[data-check="title"] .fs-check-icon').text('✅').css('color', '#4caf50');
            score++;
        } else {
            $('.fs-check-item[data-check="title"] .fs-check-icon').text('❌').css('color', '#f44336');
        }
        
        // بررسی توضیحات
        if (description && description.length >= 50 && description.length <= 160) {
            $('.fs-check-item[data-check="description"] .fs-check-icon').text('✅').css('color', '#4caf50');
            score++;
        } else {
            $('.fs-check-item[data-check="description"] .fs-check-icon').text('❌').css('color', '#f44336');
        }
        
        // بررسی کلمه کلیدی
        if (focusKeyword) {
            $('.fs-check-item[data-check="keyword"] .fs-check-icon').text('✅').css('color', '#4caf50');
            score++;
        } else {
            $('.fs-check-item[data-check="keyword"] .fs-check-icon').text('❌').css('color', '#f44336');
        }
        
        // محاسبه امتیاز
        var percentage = Math.round((score / totalChecks) * 100);
        $('#fs-score-value').text(percentage);
        $('#fs-score-fill').css('width', percentage + '%');
        
        // تغییر رنگ امتیاز
        var scoreFill = $('#fs-score-fill');
        if (percentage >= 75) {
            scoreFill.css('background', '#4caf50');
        } else if (percentage >= 50) {
            scoreFill.css('background', '#ff9800');
        } else {
            scoreFill.css('background', '#f44336');
        }
    }
    
    // آنالیز هنگام تایپ
    $('#fs_focus_keyword, #fs_meta_title, #fs_meta_description').on('input', analyzeSEO);
    
    // آنالیز اولیه
    setTimeout(analyzeSEO, 1000);
});